import React from 'react'
import { Outlet, Link, useNavigate } from 'react-router-dom'
import TopNav from './components/TopNav.jsx'

import Toasts from './components/Toasts.jsx'
import ColorTestManager from './components/ColorTestManager.jsx'
import SideNav from './components/SideNav.jsx'

export default function App() {
  return (
    <div className="min-h-screen flex flex-col">
      <TopNav />
      <div className="flex flex-1">
        <aside className="w-64 shrink-0 border-r border-onme-softBlue bg-white/70 backdrop-blur">
          <SideNav />
        </aside>
        <main className="flex-1 px-4 sm:px-6 lg:px-8 pt-4 pb-10 overflow-x-hidden">

          <Outlet />
        </main>
      </div>
      <footer className="text-center text-sm py-6 text-gray-600">
        <span className="heading text-onme-blue">KlungKlung</span> · E‑Learning for Kids · ONME palette
      </footer>
      <Toasts />
      <ColorTestManager />
    </div>
  )
}
