import React from 'react'

export default function ColorBlindnessFilters() {
    return (
        <svg style={{ position: 'fixed', top: 0, left: 0, width: 0, height: 0, overflow: 'hidden', pointerEvents: 'none', zIndex: -1 }} aria-hidden="true">
            <defs>
                {/* 
                    CORRECTION / ASSISTANCE FILTERS
                    
                    These filters shift colors to improve distinguishability.
                    Strategy: Inject information from the "invisible" channel into a "visible" channel (e.g., Blue).
                    
                    Protanopia (Red-Blind): Reds look dark/brown. We inject Red info into Blue channel making Reds -> Magenta.
                    Deuteranopia (Green-Blind): Greens look similar to Reds. We inject Green info into Blue channel making Greens -> Cyan.
                    Tritanopia (Blue-Blind): Blues look green/dim. We inject Blue info into Red channel making Blues -> Magenta.
                */}

                {/* Protanopia: Inject Red into Blue (Blue = Blue + 0.7 * Red) */}
                <filter id="protanopia">
                    <feColorMatrix
                        type="matrix"
                        values="1, 0, 0, 0, 0
                                0, 1, 0, 0, 0
                                0.7, 0, 1, 0, 0
                                0, 0, 0, 1, 0"
                    />
                </filter>
                {/* Protanomaly: Mild injection (0.35) */}
                <filter id="protanomaly">
                    <feColorMatrix
                        type="matrix"
                        values="1, 0, 0, 0, 0
                                0, 1, 0, 0, 0
                                0.35, 0, 1, 0, 0
                                0, 0, 0, 1, 0"
                    />
                </filter>

                {/* Deuteranopia: Inject Green into Blue (Blue = Blue + 0.7 * Green) */}
                <filter id="deuteranopia">
                    <feColorMatrix
                        type="matrix"
                        values="1, 0, 0, 0, 0
                                0, 1, 0, 0, 0
                                0, 0.7, 1, 0, 0
                                0, 0, 0, 1, 0"
                    />
                </filter>
                {/* Deuteranomaly: Mild injection (0.35) */}
                <filter id="deuteranomaly">
                    <feColorMatrix
                        type="matrix"
                        values="1, 0, 0, 0, 0
                                0, 1, 0, 0, 0
                                0, 0.35, 1, 0, 0
                                0, 0, 0, 1, 0"
                    />
                </filter>

                {/* Tritanopia: Inject Blue into Red (Red = Red + 0.7 * Blue) */}
                <filter id="tritanopia">
                    <feColorMatrix
                        type="matrix"
                        values="1, 0, 0.7, 0, 0
                                0, 1, 0, 0, 0
                                0, 0, 1, 0, 0
                                0, 0, 0, 1, 0"
                    />
                </filter>
                {/* Tritanomaly: Mild injection (0.35) */}
                <filter id="tritanomaly">
                    <feColorMatrix
                        type="matrix"
                        values="1, 0, 0.35, 0, 0
                                0, 1, 0, 0, 0
                                0, 0, 1, 0, 0
                                0, 0, 0, 1, 0"
                    />
                </filter>

                {/* Achromatopsia: High Contrast Grayscale with Gamma Boost */}
                <filter id="achromatopsia">
                    <feColorMatrix
                        type="matrix"
                        values="0.2126, 0.7152, 0.0722, 0, 0
                                0.2126, 0.7152, 0.0722, 0, 0
                                0.2126, 0.7152, 0.0722, 0, 0
                                0, 0, 0, 1, 0"
                    />
                    <feComponentTransfer>
                        <feFuncR type="gamma" amplitude="1.4" exponent="0.6" offset="0" />
                        <feFuncG type="gamma" amplitude="1.4" exponent="0.6" offset="0" />
                        <feFuncB type="gamma" amplitude="1.4" exponent="0.6" offset="0" />
                    </feComponentTransfer>
                </filter>
            </defs>
        </svg>
    )
}
