import React from 'react'
import { sfx } from '../utils/audio'

export default function ColorTestConsent({ userName, onStart, onSkip }) {
  const [dontShow, setDontShow] = React.useState(false)
  return (
    <div className="fixed inset-0 z-50 flex items-center justify-center bg-slate-900/90 backdrop-blur-sm p-4">
      <div className="w-full max-w-lg bg-white rounded-3xl shadow-2xl p-8 text-center relative overflow-hidden">
        {/* Decorative Background Elements */}
        <div className="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-indigo-500 via-purple-500 to-pink-500" />
        <div className="absolute -top-10 -right-10 w-32 h-32 bg-yellow-100 rounded-full blur-2xl opacity-50" />
        <div className="absolute -bottom-10 -left-10 w-32 h-32 bg-blue-100 rounded-full blur-2xl opacity-50" />

        <div className="relative z-10">
          <div className="text-6xl mb-4">🦅</div>
          <h3 className="text-2xl font-bold text-slate-800 mb-2">Misi Mata Elang!</h3>
          <p className="text-slate-600 mb-6 leading-relaxed">
            Halo <b>{userName || 'Petualang'}</b>! 👋 <br />
            Ayo kita main tebak angka sebentar untuk melihat seberapa tajam penglihatanmu.
            Nanti hasilnya akan membantumu belajar lebih nyaman!
          </p>

          <div className="bg-indigo-50 rounded-xl p-4 mb-6 text-left">
            <h4 className="font-bold text-indigo-700 text-sm mb-1">🎯 Misi Kamu:</h4>
            <ul className="text-sm text-indigo-600 space-y-1">
              <li>1. Lihat gambar yang muncul.</li>
              <li>2. Ketik angka yang kamu lihat.</li>
              <li>3. Kumpulkan poin sebanyak-banyaknya!</li>
            </ul>
          </div>

          <label className="flex items-center justify-center gap-2 mb-6 cursor-pointer group">
            <div className="relative">
              <input type="checkbox" checked={dontShow} onChange={e => setDontShow(e.target.checked)} className="peer sr-only" />
              <div className="w-5 h-5 border-2 border-slate-300 rounded transition-colors peer-checked:bg-indigo-500 peer-checked:border-indigo-500" />
              <svg className="w-3 h-3 text-white absolute top-1 left-1 opacity-0 peer-checked:opacity-100 transition-opacity" fill="none" viewBox="0 0 24 24" stroke="currentColor" strokeWidth="3"><path strokeLinecap="round" strokeLinejoin="round" d="M5 13l4 4L19 7" /></svg>
            </div>
            <span className="text-sm text-slate-500 group-hover:text-slate-700 transition-colors">Jangan tampilkan misi ini lagi</span>
          </label>

          <div className="flex flex-col gap-3">
            <button
              onClick={() => { sfx.play('success'); onStart?.({ dontShow }) }}
              className="w-full bg-gradient-to-r from-indigo-500 to-purple-600 text-white font-bold py-3 rounded-xl shadow-lg hover:shadow-xl hover:scale-[1.02] active:scale-[0.98] transition-all"
            >
              🚀 Siap, Mulai Misi!
            </button>
            <button
              onClick={() => { sfx.play('click'); onSkip?.({ dontShow }) }}
              className="text-slate-400 text-sm font-medium hover:text-slate-600 transition-colors"
            >
              Nanti saja deh
            </button>
          </div>
        </div>
      </div>
    </div>
  )
}
