import React from 'react'

export default function ColorTestResult({ result, onClose, onDetail }) {
  const { classification = 'Normal', severity = 'none' } = result || {}

  // Kid-friendly result mapping
  let title = "Hebat! 🎉"
  let message = "Mata kamu tajam seperti elang! Kamu bisa melihat semua warna dengan sangat baik."
  let icon = "🦅"
  let color = "text-green-600"

  if (classification !== 'Normal') {
    title = "Kamu Spesial! 🌟"
    icon = "🎨"
    color = "text-indigo-600"

    // Friendly name map
    const typeName = classification
      .replace('Protanopia', 'Protan (Merah)')
      .replace('Protanomali', 'Protan (Merah)')
      .replace('Deuteranopia', 'Deutan (Hijau)')
      .replace('Deuteranomali', 'Deutan (Hijau)')
      .replace('Tritanopia', 'Tritan (Biru)')
      .replace('Tritanomali', 'Tritan (Biru)')
      .replace('Monochromacy', 'Monokromasi')
      .replace('Achromatopsia', 'Akromatopsia')

    if (classification.includes('Protan')) {
      message = `Matamu unik! Tipe penglihatanmu disebut **${typeName}**. Kamu mungkin melihat warna merah sedikit berbeda dari temanmu. Tapi tenang, itu kekuatan spesialmu!`
    } else if (classification.includes('Deuteran')) {
      message = `Matamu unik! Tipe penglihatanmu disebut **${typeName}**. Kamu mungkin melihat warna hijau sedikit berbeda dari temanmu. Tapi tenang, itu kekuatan spesialmu!`
    } else if (classification.includes('Tritan')) {
      message = `Matamu unik! Tipe penglihatanmu disebut **${typeName}**. Kamu mungkin melihat warna biru sedikit berbeda dari temanmu. Tapi tenang, itu kekuatan spesialmu!`
    } else {
      message = `Dunia di matamu sangat unik! Tipe penglihatanmu disebut **${typeName}**. Kamu melihat warna dengan caramu sendiri yang spesial.`
    }
  }

  return (
    <div className="fixed inset-0 z-50 flex items-center justify-center bg-slate-900/90 backdrop-blur-sm p-4">
      <div className="w-full max-w-lg bg-white rounded-3xl shadow-2xl p-8 text-center relative overflow-hidden">
        {/* Decorative Background Elements */}
        <div className="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-green-400 via-teal-500 to-blue-500" />
        <div className="absolute -top-10 -left-10 w-32 h-32 bg-green-100 rounded-full blur-2xl opacity-50" />
        <div className="absolute -bottom-10 -right-10 w-32 h-32 bg-purple-100 rounded-full blur-2xl opacity-50" />

        <div className="relative z-10">
          <div className="text-6xl mb-4 animate-bounce">{icon}</div>
          <h3 className={`text-3xl font-bold mb-3 ${color}`}>{title}</h3>
          <p className="text-slate-600 mb-8 text-lg leading-relaxed">
            {message.split('**').map((part, i) =>
              i % 2 === 1 ? <strong key={i} className="text-indigo-600">{part}</strong> : part
            )}
          </p>

          <div className="flex flex-col gap-3">
            <button
              onClick={onClose}
              className="w-full bg-gradient-to-r from-green-500 to-teal-600 text-white font-bold py-3 rounded-xl shadow-lg hover:shadow-xl hover:scale-[1.02] active:scale-[0.98] transition-all"
            >
              Hore! Selesai
            </button>
            <button
              onClick={onDetail}
              className="text-slate-400 text-sm font-medium hover:text-slate-600 transition-colors"
            >
              Lihat detail untuk orang tua/guru
            </button>
          </div>
        </div>
      </div>
    </div>
  )
}
