import React from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { sfx } from '../utils/audio'

export default function CustomModal({ isOpen, title, message, type = 'alert', onConfirm, onCancel, confirmText = 'OK', cancelText = 'Batal' }) {
    if (!isOpen) return null

    return (
        <AnimatePresence>
            <div className="fixed inset-0 z-[100] flex items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
                <motion.div
                    initial={{ opacity: 0, scale: 0.9 }}
                    animate={{ opacity: 1, scale: 1 }}
                    exit={{ opacity: 0, scale: 0.9 }}
                    className="bg-white rounded-2xl shadow-2xl max-w-sm w-full p-6 border-4 border-onme-softBlue"
                >
                    <h3 className="heading text-xl text-onme-blue mb-2">{title || (type === 'confirm' ? 'Konfirmasi' : 'Info')}</h3>
                    <p className="text-gray-600 mb-6 font-medium">{message}</p>

                    <div className="flex gap-3 justify-end">
                        {type === 'confirm' && (
                            <button
                                onClick={() => { sfx.play('click'); onCancel?.() }}
                                className="ui px-4 py-2 rounded-xl border-2 border-slate-200 text-slate-500 font-bold hover:bg-slate-50 transition-colors"
                            >
                                {cancelText}
                            </button>
                        )}
                        <button
                            onClick={() => { sfx.play('click'); onConfirm?.() }}
                            className="ui px-6 py-2 rounded-xl bg-onme-blue text-white font-bold shadow-lg hover:bg-indigo-600 transition-transform active:scale-95"
                        >
                            {confirmText}
                        </button>
                    </div>
                </motion.div>
            </div>
        </AnimatePresence>
    )
}
