import React from 'react'
import { Navigate, Outlet, useLocation } from 'react-router-dom'
import { getUser } from '../utils/storage'

export default function RequireAuth({ children }){
  const user = getUser()
  const location = useLocation()
  if (!user) {
    return <Navigate to="/auth" replace state={{ from: location.pathname }} />
  }
  return children ?? <Outlet />
}
