import React from 'react'
import { createRoot } from 'react-dom/client'
import { createBrowserRouter, RouterProvider } from 'react-router-dom'
import './index.css'
import App from './App.jsx'
import Home from './pages/Home.jsx'
import Friends from './pages/Friends.jsx'
import Course from './pages/Course.jsx'
import MiniGames from './pages/MiniGames.jsx'
import Profile from './pages/Profile.jsx'
import Settings from './pages/Settings.jsx'
import Auth from './pages/Auth.jsx'
import RequireAuth from './components/RequireAuth.jsx'
import { ColorBlindnessProvider } from './context/ColorBlindnessContext.jsx'

const router = createBrowserRouter([
  { path: '/auth', element: <Auth /> },
  {
    path: '/',
    element: (
      <RequireAuth>
        <App />
      </RequireAuth>
    ),
    children: [
      { index: true, element: <Home /> },
      { path: 'course/:id', element: <Course /> },
      { path: 'games', element: <MiniGames /> },
      { path: 'friends', element: <Friends /> },
      { path: 'profile', element: <Profile /> },
      { path: 'settings', element: <Settings /> },
    ],
  },
])

createRoot(document.getElementById('root')).render(
  <React.StrictMode>
    <ColorBlindnessProvider>
      <RouterProvider router={router} />
    </ColorBlindnessProvider>
  </React.StrictMode>
)
