<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game Station Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            background-color: #0f172a;
            /* Slate 900 */
            color: #e2e8f0;
            /* Slate 200 */
            font-family: 'Inter', sans-serif;
        }

        .glass-panel {
            background: rgba(30, 41, 59, 0.7);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .btn-primary {
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(79, 70, 229, 0.4);
        }

        .btn-secondary {
            background: rgba(51, 65, 85, 0.5);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .btn-secondary:hover {
            background: rgba(51, 65, 85, 0.8);
            transform: translateY(-2px);
        }

        .btn-disabled {
            background: rgba(30, 41, 59, 0.5);
            color: #64748b;
            cursor: not-allowed;
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
</head>

<body class="h-screen w-full flex items-center justify-center overflow-hidden relative">

    <!-- Background Elements -->
    <div class="absolute top-0 left-0 w-full h-full overflow-hidden -z-10">
        <div
            class="absolute top-1/4 left-1/4 w-96 h-96 bg-indigo-600 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob">
        </div>
        <div
            class="absolute top-1/3 right-1/4 w-96 h-96 bg-purple-600 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob animation-delay-2000">
        </div>
        <div
            class="absolute -bottom-8 left-1/3 w-96 h-96 bg-pink-600 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-blob animation-delay-4000">
        </div>
    </div>

    <div
        class="glass-panel p-8 md:p-12 rounded-2xl shadow-2xl max-w-md w-full mx-4 text-center border border-slate-700/50">
        <div class="mb-8">
            <h1
                class="text-3xl md:text-4xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-indigo-400 to-cyan-400 mb-2">
                GAME STATION
            </h1>
            <p class="text-slate-400 text-sm tracking-widest uppercase">Dashboard</p>
        </div>

        <div class="space-y-4">
            <!-- Button 1: Mainkan Pico Park -->
            <a href="index.php?game_id=1&spawn=entrance"
                class="btn-primary block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Mainkan Pico Park
                </span>
            </a>

            <!-- Button 2: Game Kedua (Misi Angkasa Luar) -->
            <a href="index.php?game_id=2&spawn=entrance"
                class="btn-primary block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                    Misi Angkasa Luar
                </span>
            </a>

            <!-- Button 3: Game Ketiga (Neon Dash: Math) -->
            <a href="index.php?game_id=3&spawn=entrance"
                class="block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden"
                style="background: linear-gradient(135deg, #ec4899 0%, #8b5cf6 100%); transition: all 0.3s ease;">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                    Neon Dash: Math
                </span>
            </a>

            <!-- Button 4: Game Keempat (Flappy English) -->
            <a href="index.php?game_id=4&spawn=entrance"
                class="block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden"
                style="background: linear-gradient(135deg, #f97316 0%, #eab308 100%); transition: all 0.3s ease;">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                    </svg>
                    Flappy English
                </span>
            </a>

            <!-- Button 5: Game Kelima (English Burger Master) -->
            <a href="index.php?game_id=5&spawn=entrance"
                class="block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden"
                style="background: linear-gradient(135deg, #d97706 0%, #92400e 100%); transition: all 0.3s ease;">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M21 15.546c-.523 0-1.046.151-1.5.454a2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0A1.5 1.5 0 003 15.546V12a9 9 0 1118 0v3.546z" />
                    </svg>
                    🍔 Burger Master
                </span>
            </a>

            <!-- Button 6: Game Keenam (Fruit Word Ninja) -->
            <a href="index.php?game_id=6&spawn=entrance"
                class="block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden"
                style="background: linear-gradient(135deg, #84cc16 0%, #365314 100%); transition: all 0.3s ease;">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M14.121 14.121L19 19m-7-7l7-7m-7 7l-2.879 2.879M12 12L9.121 9.121m0 5.758a3 3 0 10-4.243 4.243 3 3 0 004.243-4.243z" />
                    </svg>
                    🍉 Word Ninja
                </span>
            </a>

            <!-- Button 7: Game Ketujuh (IPS Hoops) -->
            <a href="index.php?game_id=7&spawn=entrance"
                class="block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden"
                style="background: linear-gradient(135deg, #ea580c 0%, #1e293b 100%); transition: all 0.3s ease;">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 3c4.97 0 9 4.03 9 9s-4.03 9-9 9-9-4.03-9-9 4.03-9 9-9zM12 3v18M3 12h18" />
                    </svg>
                    🏀 IPS Hoops
                </span>
            </a>

            <!-- Button 8: Game Kedelapan (Moto Quiz GP) -->
            <a href="index.php?game_id=8&spawn=entrance"
                class="block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden"
                style="background: linear-gradient(135deg, #ef4444 0%, #facc15 100%); transition: all 0.3s ease;">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                    🏍️ Moto Quiz GP
                </span>
            </a>

            <!-- Button 9: Game Kesembilan (Pac-Siswa) -->
            <a href="index.php?game_id=9&spawn=entrance"
                class="block w-full py-4 rounded-xl text-white font-bold text-lg shadow-lg group relative overflow-hidden"
                style="background: linear-gradient(135deg, #fbbf24 0%, #1e3a8a 100%); transition: all 0.3s ease;">
                <span class="relative z-10 flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    👻 Pac-Siswa IPS
                </span>
            </a>

            <div class="h-4"></div> <!-- Spacer -->

            <!-- Button Back: Kembali ke Lobby -->
            <a href="index.php?spawn=entrance"
                class="btn-secondary block w-full py-3 rounded-xl text-slate-300 font-medium hover:text-white">
                <span class="flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                    Kembali ke Lobby
                </span>
            </a>
        </div>
    </div>

    <style>
        @keyframes blob {
            0% {
                transform: translate(0px, 0px) scale(1);
            }

            33% {
                transform: translate(30px, -50px) scale(1.1);
            }

            66% {
                transform: translate(-20px, 20px) scale(0.9);
            }

            100% {
                transform: translate(0px, 0px) scale(1);
            }
        }

        .animate-blob {
            animation: blob 7s infinite;
        }

        .animation-delay-2000 {
            animation-delay: 2s;
        }

        .animation-delay-4000 {
            animation-delay: 4s;
        }
    </style>
</body>

</html>
