<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>GLB Viewer - FPP Mode</title>
    <!-- Tailwind CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <!-- Nipple.js for Joystick -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/nipplejs/0.10.1/nipplejs.min.js"></script>
    <!-- Custom CSS -->
    <link rel="stylesheet" href="./css/style.css">
    <style>
        /* Mobile Optimizations */
        @media (max-width: 768px) {



            /* Hide Debug Log on Mobile */
            #debug-log {
                display: none !important;
            }

            /* Hide Navbar completely on mobile for more screen space */
            nav {
                display: none !important;
            }

            /* Make body fullscreen container on mobile */
            body {
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100vw !important;
                height: 100vh !important;
                overflow: hidden !important;
                margin: 0 !important;
                padding: 0 !important;
            }

            /* Make canvas fill entire viewport */
            canvas {
                position: fixed !important;
                top: 0 !important;
                left: 0 !important;
                width: 100vw !important;
                height: 100vh !important;
                object-fit: contain !important;
            }

            /* Ensure Joystick Zone is visible */
            #joystick-zone {
                position: absolute !important;
                bottom: 0;
                left: 0;
                width: 50%;
                height: 50%;
                z-index: 100 !important;
                pointer-events: auto !important;
            }

            /* Lower z-index of info panel to let buttons appear on top */
            .absolute.top-16.right-4 {
                z-index: 50 !important;
            }

            /* Show Buttons on Mobile - BOTTOM RIGHT to avoid browser UI */
            #fullscreen-btn {
                display: block !important;
                position: fixed !important;
                bottom: 20px !important;
                right: 20px !important;
                top: auto !important;
                left: auto !important;
                z-index: 200 !important;
            }

            #refresh-btn {
                display: block !important;
                position: fixed !important;
                bottom: 80px !important;
                right: 20px !important;
                top: auto !important;
                left: auto !important;
                z-index: 200 !important;
            }
        }

        /* LANDSCAPE MODE SPECIFIC - Custom layout */
        @media (max-width: 768px) and (orientation: landscape) {

            /* Keep info panel visible in landscape */
            .absolute.top-16.right-4 {
                display: block !important;
                z-index: 50 !important;
            }

            /* Position buttons BELOW info panel (right side, stacked vertically) */
            #fullscreen-btn {
                top: 220px !important;
                /* Closer to info panel */
                right: 20px !important;
                left: auto !important;
                bottom: auto !important;
            }

            #refresh-btn {
                top: 280px !important;
                /* Below fullscreen, closer spacing */
                right: 20px !important;
                left: auto !important;
                bottom: auto !important;
            }
        }
    </style>
</head>

<body>
    <!-- Tutorial Modal (Glassmorphism) -->
    <div id="tutorial-modal" class="hidden" 
        style="display: none;
               position: fixed; top: 0; left: 0; right: 0; bottom: 0; 
               align-items: center; justify-content: center;
               z-index: 999999 !important; 
               background: rgba(0,0,0,0.7); 
               backdrop-filter: blur(8px); 
               pointer-events: auto;">
        <div style="background: #1e293b; 
                    border: 2px solid #22d3ee; 
                    border-radius: 16px; 
                    padding: 30px; 
                    max-width: 420px; 
                    margin: 20px;
                    box-shadow: 0 0 40px rgba(34, 211, 238, 0.5);
                    text-align: center;">
            <h2 id="tut-title" style="color: #22d3ee; font-size: 28px; font-weight: bold; margin-bottom: 15px; font-family: Arial, sans-serif;">
                ✨ Selamat Datang!
            </h2>
            <p id="tut-text" style="color: #e2e8f0; font-size: 16px; line-height: 1.6; margin-bottom: 25px; font-family: Arial, sans-serif;">
                Gunakan Joystick/WASD untuk bergerak. Temukan 2 Teleporter di depan untuk mulai Belajar atau Bermain.
            </p>
            <button id="tut-btn" style="width: 100%; 
                                        background: linear-gradient(135deg, #22d3ee, #06b6d4); 
                                        color: #0f172a; 
                                        font-size: 18px; 
                                        font-weight: bold; 
                                        padding: 15px 30px; 
                                        border: none; 
                                        border-radius: 10px; 
                                        cursor: pointer;
                                        font-family: Arial, sans-serif;
                                        box-shadow: 0 4px 15px rgba(34, 211, 238, 0.4);
                                        transition: transform 0.2s, box-shadow 0.2s;">
                MENGERTI
            </button>
        </div>
    </div>

    <!-- Floating HUD - Current Task (TENGAH ATAS) -->
    <div id="task-hud" style="position: fixed; top: 16px; left: 50%; transform: translateX(-50%);
                              z-index: 999998 !important; 
                              background: rgba(15, 23, 42, 0.9); 
                              border: 1px solid #22d3ee; 
                              border-radius: 8px; 
                              padding: 8px 16px; 
                              backdrop-filter: blur(8px); 
                              pointer-events: auto;
                              font-family: Arial, sans-serif;">
        <p style="margin: 0; font-size: 14px; color: #d1d5db;">
            <span style="color: #22d3ee; font-weight: 600;">📍 Tugas:</span> 
            <span id="current-task" style="color: white;">Eksplorasi Area</span>
        </p>
    </div>

    <!-- DEBUG: Test Tutorial Button (TENGAH BAWAH - Hapus setelah testing) -->
    <button id="debug-tutorial-btn" onclick="sessionStorage.clear(); location.reload();" 
        style="position: fixed; bottom: 16px; left: 50%; transform: translateX(-50%);
               z-index: 999998 !important; 
               background: #dc2626; 
               color: white; 
               font-weight: bold; 
               padding: 10px 16px; 
               border: none;
               border-radius: 8px; 
               cursor: pointer;
               font-family: Arial, sans-serif;
               font-size: 14px;
               pointer-events: auto;">
        🔄 Reset & Show Tutorial
    </button>

    <!-- SVG Filters for Color Blindness Simulation -->
    <svg style="display: none;">
        <defs>
            <!-- Protanopia (Red-Blind) -->
            <filter id="protanopia">
                <feColorMatrix type="matrix" values="
                    0.567, 0.433, 0,     0, 0
                    0.558, 0.442, 0,     0, 0
                    0,     0.242, 0.758, 0, 0
                    0,     0,     0,     1, 0" />
            </filter>
            <!-- Deuteranopia (Green-Blind) -->
            <filter id="deuteranopia">
                <feColorMatrix type="matrix" values="
                    0.625, 0.375, 0,   0, 0
                    0.7,   0.3,   0,   0, 0
                    0,     0.3,   0.7, 0, 0
                    0,     0,     0,   1, 0" />
            </filter>
            <!-- Tritanopia (Blue-Blind) -->
            <filter id="tritanopia">
                <feColorMatrix type="matrix" values="
                    0.95, 0.05,  0,     0, 0
                    0,    0.433, 0.567, 0, 0
                    0,    0.475, 0.525, 0, 0
                    0,    0,     0,     1, 0" />
            </filter>
            <!-- Achromatopsia (Monochrome/Grayscale) -->
            <filter id="achromatopsia">
                <feColorMatrix type="matrix" values="
                    0.299, 0.587, 0.114, 0, 0
                    0.299, 0.587, 0.114, 0, 0
                    0.299, 0.587, 0.114, 0, 0
                    0,     0,     0,     1, 0" />
            </filter>
        </defs>
    </svg>

    <!-- Color Blindness Mode Panel (Floating Left) -->
    <div id="vision-panel" class="fixed left-0 top-1/4 flex transition-all duration-300 ease-in-out"
        style="z-index: 99999; transform: translateX(-120px);">
        <!-- Panel Content (width: 120px) -->
        <div id="vision-content"
            class="bg-gray-900 bg-opacity-95 border-r-2 border-t-2 border-b-2 border-blue-400 rounded-r-xl p-3 shadow-lg"
            style="width: 120px;">
            <h3 class="text-white text-xs font-bold mb-2 text-center">Mode Visual</h3>
            <div class="flex flex-col gap-2">
                <button onclick="setVisionFilter('normal')" id="btn-normal"
                    class="vision-btn bg-green-600 text-white text-xs px-2 py-2 rounded-lg hover:bg-green-500 transition-colors">
                    ✓ Normal
                </button>
                <button onclick="setVisionFilter('protanopia')" id="btn-protanopia"
                    class="vision-btn bg-gray-600 text-white text-xs px-2 py-2 rounded-lg hover:bg-red-500 transition-colors">
                    🔴 Protanopia
                </button>
                <button onclick="setVisionFilter('deuteranopia')" id="btn-deuteranopia"
                    class="vision-btn bg-gray-600 text-white text-xs px-2 py-2 rounded-lg hover:bg-green-700 transition-colors">
                    🟢 Deuteranopia
                </button>
                <button onclick="setVisionFilter('tritanopia')" id="btn-tritanopia"
                    class="vision-btn bg-gray-600 text-white text-xs px-2 py-2 rounded-lg hover:bg-blue-700 transition-colors">
                    🔵 Tritanopia
                </button>
                <button onclick="setVisionFilter('achromatopsia')" id="btn-achromatopsia"
                    class="vision-btn bg-gray-600 text-white text-xs px-2 py-2 rounded-lg hover:bg-gray-500 transition-colors">
                    ⚪ Monokrom
                </button>
            </div>
            <!-- Low Graphics Mode Section -->
            <div class="border-t border-gray-600 mt-3 pt-3">
                <h4 class="text-white text-xs font-bold mb-2 text-center">🎮 Performa</h4>
                <button onclick="toggleLowGraphics()" id="btn-low-graphics"
                    class="w-full bg-gray-600 text-white text-xs px-2 py-2 rounded-lg hover:bg-orange-500 transition-colors">
                    ⚡ Grafik Rendah: OFF
                </button>
                <p class="text-gray-400 text-center mt-1" style="font-size: 9px;">Kurangi lag di HP lama</p>
            </div>
        </div>
        <!-- Tab Handle (always visible) -->
        <div id="vision-tab"
            class="bg-blue-600 text-white text-xs font-bold px-1 py-3 rounded-r-lg cursor-pointer flex items-center shadow-lg border-r-2 border-t-2 border-b-2 border-blue-400"
            style="writing-mode: vertical-rl; text-orientation: mixed; min-height: 80px;">
            👁️ VISUAL
        </div>
    </div>

    <!-- Vision Panel Script -->
    <script>
        // Panel hover/click logic
        const visionPanel = document.getElementById('vision-panel');
        const visionTab = document.getElementById('vision-tab');
        let panelOpen = false;

        function toggleVisionPanel(open) {
            panelOpen = open;
            // Panel content is 120px wide, so translate by that amount
            visionPanel.style.transform = open ? 'translateX(0)' : 'translateX(-120px)';
        }

        // Click to toggle
        visionTab.addEventListener('click', () => toggleVisionPanel(!panelOpen));

        // Hover to open (desktop)
        visionPanel.addEventListener('mouseenter', () => toggleVisionPanel(true));
        visionPanel.addEventListener('mouseleave', () => toggleVisionPanel(false));

        // Set Vision Filter Function
        let currentFilter = 'normal';
        function setVisionFilter(filterId) {
            currentFilter = filterId;

            // Apply filter to body
            if (filterId === 'normal') {
                document.body.style.filter = 'none';
            } else {
                document.body.style.filter = `url(#${filterId})`;
            }

            // Update button styles
            document.querySelectorAll('.vision-btn').forEach(btn => {
                btn.classList.remove('bg-green-600', 'ring-2', 'ring-white');
                btn.classList.add('bg-gray-600');
            });

            // Highlight active button
            const activeBtn = document.getElementById(`btn-${filterId}`);
            if (activeBtn) {
                activeBtn.classList.remove('bg-gray-600');
                activeBtn.classList.add('bg-green-600', 'ring-2', 'ring-white');
            }

            console.log(`Vision filter set to: ${filterId}`);
        }

        // Low Graphics Mode Toggle
        let lowGraphicsMode = localStorage.getItem('lowGraphicsMode') === 'true';
        
        // Initialize button state on load
        document.addEventListener('DOMContentLoaded', () => {
            updateLowGraphicsButton();
            if (lowGraphicsMode) {
                applyLowGraphicsMode(true);
            }
        });

        function toggleLowGraphics() {
            lowGraphicsMode = !lowGraphicsMode;
            localStorage.setItem('lowGraphicsMode', lowGraphicsMode);
            updateLowGraphicsButton();
            applyLowGraphicsMode(lowGraphicsMode);
            console.log(`Low Graphics Mode: ${lowGraphicsMode ? 'ON' : 'OFF'}`);
        }

        function updateLowGraphicsButton() {
            const btn = document.getElementById('btn-low-graphics');
            if (btn) {
                if (lowGraphicsMode) {
                    btn.textContent = '⚡ Grafik Rendah: ON';
                    btn.classList.remove('bg-gray-600');
                    btn.classList.add('bg-orange-600', 'ring-2', 'ring-white');
                } else {
                    btn.textContent = '⚡ Grafik Rendah: OFF';
                    btn.classList.remove('bg-orange-600', 'ring-2', 'ring-white');
                    btn.classList.add('bg-gray-600');
                }
            }
        }

        function applyLowGraphicsMode(enabled) {
            // Dispatch custom event that main.js will listen to
            window.dispatchEvent(new CustomEvent('lowGraphicsModeChanged', { 
                detail: { enabled: enabled } 
            }));
            
            // Also set a global variable for main.js to access
            window.isLowGraphicsMode = enabled;
        }
    </script>

    <!-- Navbar (Hidden) -->
    <nav class="absolute top-0 left-0 right-0 bg-gray-800 p-4 text-white text-center z-50 select-none"
        style="display: none !important;">
        <h1 class="text-lg font-bold">GLB Viewer (FPP)</h1>
    </nav>

    <!-- Fullscreen Button (Mobile Only) -->
    <button id="fullscreen-btn" style="
        display: none;
        position: absolute;
        top: 10px;
        left: 10px;
        z-index: 60;
        background: rgba(0, 0, 0, 0.5);
        color: white;
        border: 1px solid white;
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 12px;
    ">
        [ ] Fullscreen
    </button>

    <!-- Refresh Button (Mobile Only) -->
    <button id="refresh-btn" onclick="window.location.reload()" style="
        display: none; /* Shown via CSS on mobile */
        position: absolute;
        top: 10px;
        left: 110px; /* Next to Fullscreen btn */
        z-index: 60;
        background: rgba(0, 0, 0, 0.5);
        color: white;
        border: 1px solid white;
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 12px;
    ">
        ↻ Refresh
    </button>

    <!-- Controls/Info Panel -->
    <div
        class="absolute top-16 right-4 bg-gray-700 p-4 rounded-lg shadow-lg text-white z-50 opacity-80 hover:opacity-100 transition-opacity select-none">
        <h2 class="text-md font-semibold mb-2">Info</h2>
        <div>
            <p class="text-xs">Model: <span id="modelFileName">Loading...</span></p>
        </div>
        <div class="mt-2 text-xs">
            <p>Joystick: Move</p>
            <p>WASD: Move</p>
            <p>Drag Screen: Look</p>
        </div>
        <button id="resetCameraButton"
            class="mt-3 bg-blue-500 hover:bg-blue-700 text-white font-bold py-1 px-3 rounded text-sm w-full">
            Reset Position
        </button>
    </div>

    <!-- Joystick Zone -->
    <div id="joystick-zone"></div>

    <!-- Loading Bar Container -->
    <div id="loading-bar-container">
        <div id="loading-bar"></div>
    </div>

    <div id="game-popup" style="
        display: none;
        position: absolute;
        bottom: 20%;
        left: 50%;
        transform: translateX(-50%);
        padding: 15px 30px;
        background: rgba(0, 255, 0, 0.8);
        color: white;
        font-family: 'Press Start 2P', cursive;
        font-size: 16px;
        border: 2px solid white;
        border-radius: 10px;
        cursor: pointer;
        z-index: 1000;
        text-align: center;
        box-shadow: 0 0 15px rgba(0, 255, 0, 0.5);
    ">
        KLIK DISINI UNTUK MAIN GAME
    </div>

    <!-- Instructions Removed -->

    <!-- Debug Overlay (Hidden by default as requested) -->
    <div id="debug-log" style="display: none !important;">
        Initializing...
    </div>

    <!-- Interaction Button -->
    <button id="interactBtn">
        Lanjutkan
    </button>

    <!-- AI Chat Overlay -->
    <div id="chat-overlay" style="display: none; z-index: 99999 !important; pointer-events: auto !important;"
        class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 backdrop-filter backdrop-blur-sm">
        <div style="pointer-events: auto !important; height: 70vh; max-height: 500px; min-height: 350px;"
            class="bg-gray-900 bg-opacity-90 border-2 border-blue-400 rounded-xl w-11/12 max-w-lg shadow-[0_0_20px_rgba(59,130,246,0.5)] flex flex-col">
            <!-- Header (Fixed) -->
            <div class="bg-blue-600 bg-opacity-30 p-4 flex justify-between items-center border-b border-blue-400 flex-shrink-0">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 rounded-full bg-blue-500 flex items-center justify-center text-2xl">🤖</div>
                    <h2 class="text-white font-bold text-xl tracking-wider shadow-blue-glow">PAK GURU AI</h2>
                </div>
                <button id="closeChatBtn"
                    class="text-gray-300 hover:text-white hover:bg-red-500 hover:bg-opacity-50 rounded-full p-1 transition-colors">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>

            <!-- Chat History (Scrollable - Fixed Area) -->
            <div id="chat-history"
                style="flex: 1; overflow-y: auto; min-height: 0;"
                class="p-4 space-y-4">
                <!-- Welcome Message -->
                <div class="flex items-start gap-3">
                    <div
                        class="w-8 h-8 rounded-full bg-blue-500 flex-shrink-0 flex items-center justify-center text-sm">
                        🤖</div>
                    <div
                        class="bg-blue-900 bg-opacity-50 text-blue-100 p-3 rounded-lg rounded-tl-none border border-blue-500 shadow-md max-w-[85%]">
                        Halo! Saya Pak Guru AI. Ada yang bisa saya bantu tentang pelajaran hari ini?
                    </div>
                </div>
            </div>

            <!-- Input Area (Fixed at Bottom) -->
            <div class="p-4 bg-gray-800 bg-opacity-50 border-t border-blue-400 flex-shrink-0">
                <div class="flex gap-2">
                    <input type="text" id="chatInput" placeholder="Tanya Pak Guru..."
                        class="flex-1 bg-gray-700 text-white border border-gray-600 rounded-lg px-4 py-2 focus:outline-none focus:border-blue-400 focus:ring-1 focus:ring-blue-400 placeholder-gray-400">
                    <button id="micBtn" title="Tekan untuk bicara"
                        class="bg-gray-600 hover:bg-red-500 text-white font-bold py-2 px-4 rounded-lg transition-colors shadow-lg border border-gray-500">
                        🎤
                    </button>
                    <button id="sendChatBtn"
                        class="bg-blue-600 hover:bg-blue-500 text-white font-bold py-2 px-6 rounded-lg transition-colors shadow-lg border border-blue-400">
                        Kirim
                    </button>
                </div>
                <p id="micStatus" class="text-xs text-gray-400 mt-2 hidden">🎤 Sedang mendengarkan...</p>
            </div>
        </div>
    </div>

    <!-- Import Map -->
    <script type="importmap">
        {
            "imports": {
                "three": "https://unpkg.com/three@0.160.0/build/three.module.js",
                "three/addons/": "https://unpkg.com/three@0.160.0/examples/jsm/"
            }
        }
    </script>

    <!-- Main Logic -->
    <script type="module">
        import { init } from './js/main.js?v=73';

        // Start the application!
        init();
    </script>
</body>

</html>
